/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.mixin.structures.PoolElementStructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MonumentPieces;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class MonumentStructure
extends class_3195 {
    public static final Codec<MonumentStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MonumentStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("monument_type").forGetter(config -> config.monumentType), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(config -> config.biomeRadius), (App)Codec.INT.optionalFieldOf("fixed_y_spawn").forGetter(config -> config.fixedYSpawn), (App)Codec.FLOAT.optionalFieldOf("center_terrain_height_weight").forGetter(config -> config.centerTerrainHeightWeight)).apply((Applicative)instance, MonumentStructure::new));
    public final String monumentType;
    public final Optional<Integer> biomeRadius;
    public final Optional<Integer> fixedYSpawn;
    public final Optional<Float> centerTerrainHeightWeight;

    public MonumentStructure(class_3195.class_7302 config, String monumentType, Optional<Integer> biomeRadius, Optional<Integer> fixedYSpawn, Optional<Float> centerTerrainHeightWeight) {
        super(config);
        this.monumentType = monumentType.toLowerCase(Locale.ROOT);
        this.biomeRadius = biomeRadius;
        this.fixedYSpawn = fixedYSpawn;
        this.centerTerrainHeightWeight = centerTerrainHeightWeight;
    }

    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        class_1923 chunkPos = context.comp_568();
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = this.biomeRadius.get();
            for (int curChunkX = chunkPos.field_9181 - validBiomeRange; curChunkX <= chunkPos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - validBiomeRange; curChunkZ <= chunkPos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        int finalheight;
        class_1923 chunkPos = context.comp_568();
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        class_2338 centerPoint = chunkPos.method_33943(0);
        if (this.fixedYSpawn.isPresent()) {
            finalheight = this.fixedYSpawn.get();
        } else {
            int centerHight;
            float centerWeight = this.centerTerrainHeightWeight.orElse(Float.valueOf(1.0f)).floatValue();
            int highestLandPos = centerHight = context.comp_562().method_18028(centerPoint.method_10263(), centerPoint.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(centerPoint.method_10263() + 29, centerPoint.method_10260() + 29, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()));
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(centerPoint.method_10263() - 29, centerPoint.method_10260() + 29, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()));
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(centerPoint.method_10263() + 29, centerPoint.method_10260() - 29, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()));
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(centerPoint.method_10263() - 29, centerPoint.method_10260() - 29, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()));
            finalheight = (int)((float)(highestLandPos - centerHight) / centerWeight) + centerHight;
        }
        if (finalheight <= context.comp_562().method_33730()) {
            return Optional.empty();
        }
        if (!this.extraSpawningChecks(context, chunkPos.method_33943(finalheight))) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(chunkPos.method_33943(finalheight), structurePiecesBuilder -> {
            List<class_3443> list = MonumentPieces.createMonumentBuilding(context.comp_561(), context.comp_565(), (class_5819)random, centerPoint.method_10263(), finalheight, centerPoint.method_10260(), this.monumentType);
            class_2470 rotation = class_2470.method_16548((class_5819)random);
            class_2338 mainOffset = new class_2338(-29, 0, -29).method_10070(rotation);
            for (class_3443 structurePiece : list) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolPiece = (class_3790)structurePiece;
                ((PoolElementStructurePieceAccessor)poolPiece).setRotation(poolPiece.method_16888().method_10501(rotation));
                class_2338 piecePos = poolPiece.method_16648();
                class_2338 offsetPos = piecePos.method_10059((class_2382)centerPoint);
                class_2338 rotatedOffset = offsetPos.method_10070(rotation);
                poolPiece.method_14922(rotatedOffset.method_10263() - offsetPos.method_10263(), 0, rotatedOffset.method_10260() - offsetPos.method_10260());
                poolPiece.method_14922(mainOffset.method_10263(), 0, mainOffset.method_10260());
                class_3784 patt8010$temp = poolPiece.method_16644();
                if (!(patt8010$temp instanceof class_3781)) continue;
                class_3781 singlePoolElement = (class_3781)patt8010$temp;
                class_3499 structuretemplate = ((SinglePoolElementAccessor)singlePoolElement).callGetTemplate(context.comp_565());
                ((StructurePieceAccessor)poolPiece).setBoundingBox(structuretemplate.method_16187(new class_3492().method_15123(rotation), poolPiece.method_16648()));
            }
            list.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
        }));
    }

    public class_7151<?> method_41618() {
        return RSStructures.MONUMENT_STRUCTURE;
    }
}

